<article class="product product-detail">
  

  <?php
    $isVariable = ($product['product_type'] ?? 'simple') === 'variable';
    // Compute "From £" for variable products
    $minPrice = null;
    if ($isVariable && !empty($variants)) {
      foreach ($variants as $v) {
        $pm = (int)$v['price_minor'];
        if ($minPrice === null || $pm < $minPrice) $minPrice = $pm;
      }
    }
  ?>

  <div class="product-layout">
    <!-- LEFT: Image -->
    <div class="product-media">
      <?php if (!empty($product['image'])): ?>
        <figure>
          <img class="product-image"
               src="<?php echo htmlspecialchars($asset($product['image'])); ?>"
               alt="<?php echo htmlspecialchars($product['name']); ?>">
        </figure>
      <?php else: ?>
        <div class="product-image placeholder">No image</div>
      <?php endif; ?>
    </div>

    <!-- RIGHT: Buy box + description -->
    <div class="product-info">

		<h1 class="product-title"><?php echo htmlspecialchars($product['name']); ?></h1>
      <!-- Price -->
      <?php if ($isVariable): ?>
        <?php if ($minPrice !== null): ?>
          <p class="price">From £<?php echo number_format($minPrice/100, 2); ?></p>
        <?php else: ?>
          <p class="price muted">No variants available</p>
        <?php endif; ?>
      <?php else: ?>
        <p class="price">£<?php echo number_format($product['price_minor']/100, 2); ?></p>
      <?php endif; ?>

		<!-- Description -->
      <?php if (!empty($product['description'])): ?>
        <div class="product-description">
          <?php echo nl2br(htmlspecialchars($product['description'])); ?>
        </div>
      <?php endif; ?>
      <!-- Add to cart -->
      <form method="post" action="/index.php?page=add_to_cart" class="buy-form">
        <?php echo CSRF::input(); ?>
        <input type="hidden" name="product_id" value="<?php echo (int)$product['id']; ?>">

        <?php if ($isVariable): ?>
          <label class="field">
            <span>Choose a variant</span>
            <select name="variant_id" required>
              <option value="">— Select —</option>
              <?php foreach ($variants as $v): ?>
                <?php
                  // Build a readable label from attributes_json
                  $label = '';
                  $attrs = json_decode($v['attributes_json'] ?? '[]', true) ?: [];
                  if ($attrs) {
                      $parts = [];
                      foreach ($attrs as $k => $val) {
                          $k = preg_replace('~^attribute_(pa_)?~', '', (string)$k);
                          $k = str_replace(['-', '_'], ' ', $k);
                          $parts[] = ucfirst($k).': '.ucfirst((string)$val);
                      }
                      $label = implode(' · ', $parts);
                  }
                  if ($label === '') $label = 'Variant #'.(int)$v['id'];
                  $label .= ' — £'.number_format($v['price_minor']/100, 2);
                ?>
                <option value="<?php echo (int)$v['id']; ?>">
                  <?php echo htmlspecialchars($label); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </label>
        <?php endif; ?>

        <label class="field qty">
          <span>Qty</span>
          <input type="number" name="qty" min="1" value="1">
        </label>

        <button type="submit" class="button"
                <?php echo ($isVariable && empty($variants)) ? 'disabled' : ''; ?>>
          Add to cart
        </button>
      </form>

      

    </div>
  </div>
</article>
