<?php if (empty($sections)): ?>
  <h1>Products</h1>
  <p class="muted">No active products found.</p>
<?php else: ?>
  <?php foreach ($sections as $s): $c = $s['category']; $ps = $s['products']; ?>
    <h1 class="rule"><?php echo htmlspecialchars($c['name']); ?></h1>

    <div class="grid">
      <?php foreach ($ps as $p): ?>
        <?php $isVariable = (($p['product_type'] ?? 'simple') === 'variable'); ?>
        <article class="card">
          <?php if (!empty($p['image'])): ?>
			<a href="/index.php?page=product&slug=<?php echo urlencode($p['slug']); ?>">
            <img src="<?php echo htmlspecialchars($asset($p['image'])); ?>" alt="<?php echo htmlspecialchars($p['name']); ?>">
				</a>
          <?php endif; ?>

          <h2>
            <a href="/index.php?page=product&slug=<?php echo urlencode($p['slug']); ?>">
              <?php echo htmlspecialchars($p['name']); ?>
            </a>
          </h2>

          <?php if ($isVariable): ?>
            <?php $min = $p['min_variant_price_minor'] ?? null; ?>
            <?php if ($min !== null): ?>
              <p class="price">From £<?php echo number_format(((int)$min)/100, 2); ?></p>
            <?php endif; ?>
            <p>
              <a class="button" href="/index.php?page=product&slug=<?php echo urlencode($p['slug']); ?>">
                See All Variations
              </a>
            </p>
          <?php else: ?>
            <p class="price">£<?php echo number_format(((int)$p['price_minor'])/100, 2); ?></p>
            <form method="post" action="/index.php?page=add_to_cart">
              <?php echo CSRF::input(); ?>
              <input type="hidden" name="product_id" value="<?php echo (int)$p['id']; ?>">
              <label>Qty <input type="number" name="qty" min="1" value="1"></label>
              <button type="submit">Add to cart</button>
            </form>
          <?php endif; ?>
        </article>
      <?php endforeach; ?>
    </div>

    <p style="margin-top:.5rem;text-align:center;display:block">
      <a class="button" href="/index.php?page=category&slug=<?php echo urlencode($c['slug']); ?>">
        Browse <?php echo htmlspecialchars($c['name']); ?>
      </a>
    </p>
    <hr style="margin:1.5rem 0; border:0; border-top:1px solid #eee;">
  <?php endforeach; ?>
<?php endif; ?>
