<?php
// category.php

// If the controller passed $subcategory, show it in the heading.
// (Controller already filters products by sub when present.)
?>
<h1>
  <?= htmlspecialchars($category['name']) ?>
  <?php if (!empty($subcategory)): ?>
    — <span class="muted"><?= htmlspecialchars($subcategory['name']) ?></span>
  <?php endif; ?>
</h1>

<?php if (empty($products)): ?>
  <p class="muted">
    <?php if (!empty($subcategory)): ?>
      No products in this subcategory yet.
    <?php else: ?>
      No products in this category yet.
    <?php endif; ?>
  </p>
<?php else: ?>
  <div class="grid">
    <?php foreach ($products as $p): ?>
      <?php $isVariable = (($p['product_type'] ?? 'simple') === 'variable'); ?>
      <article class="card">
        <?php if (!empty($p['image'])): ?>
          <a href="/index.php?page=product&amp;slug=<?= urlencode($p['slug']) ?>">
            <img src="<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
          </a>
        <?php endif; ?>

        <h2>
          <a href="/index.php?page=product&amp;slug=<?= urlencode($p['slug']) ?>">
            <?= htmlspecialchars($p['name']) ?>
          </a>
        </h2>

        <?php if ($isVariable): ?>
          <?php $min = $p['min_variant_price_minor'] ?? null; ?>
          <?php if ($min !== null): ?>
            <p class="price">From £<?= number_format(((int)$min)/100, 2) ?></p>
          <?php endif; ?>
          <p>
            <a class="button" href="/index.php?page=product&amp;slug=<?= urlencode($p['slug']) ?>">
              See All Variations
            </a>
          </p>
        <?php else: ?>
          <p class="price">£<?= number_format(((int)$p['price_minor'])/100, 2) ?></p>
          <form method="post" action="/index.php?page=add_to_cart">
            <?= CSRF::input(); ?>
            <input type="hidden" name="product_id" value="<?= (int)$p['id'] ?>">
            <label>Qty <input type="number" name="qty" min="1" value="1"></label>
            <button type="submit">Add to cart</button>
          </form>
        <?php endif; ?>
      </article>
    <?php endforeach; ?>
  </div>
<?php endif; ?>

<p style="margin-top:1rem;text-align:center;display:block">
  <?php if (!empty($subcategory)): ?>
    <a class="button" href="/index.php?page=category&amp;slug=<?= urlencode($category['slug']) ?>">
      ← Back to <?= htmlspecialchars($category['name']) ?>
    </a>
  <?php else: ?>
    <a class="button" href="/index.php">← Back to all Categories</a>
  <?php endif; ?>
</p>
