<h1>Your Cart</h1>

<?php if (empty($lines)): ?>
  <p>Your cart is empty.</p>
<?php else: ?>
<form method="post" action="/index.php?page=update_cart">
  <?php echo CSRF::input(); ?>
  <div class="table-responsive">
	<table class="cart-table">
    <thead>
      <tr>
        <th>Product</th>
        <th style="width:120px">Qty</th>
        <th>Price</th>
        <th>Total</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($lines as $line): ?>
        <tr>
          <td><?php echo htmlspecialchars($line['name']); ?></td>
          <td>
            <input
              type="number"
              name="qty[<?php echo htmlspecialchars($line['cart_key']); ?>]"
              min="0"
              value="<?php echo (int)$line['qty']; ?>"
              style="max-width:100px"
            >
          </td>
          <td>£<?php echo number_format($line['price_minor']/100, 2); ?></td>
          <td>£<?php echo number_format($line['total_minor']/100, 2); ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="3" style="text-align:right">Subtotal</th>
        <th>£<?php echo number_format($subtotal/100, 2); ?></th>
      </tr>
    </tfoot>
  </table>
	</div>

  <p>
    <button type="submit">Update cart</button>
    <a class="button checkout-btn" href="/index.php?page=checkout">Checkout</a>
  </p>
</form>
<?php endif; ?>
