<h1>Variants for “<?php echo htmlspecialchars($product['name']); ?>”</h1>
<p><a class="button" href="/admin.php?action=variant_new&product_id=<?php echo (int)$product['id']; ?>">Add Variant</a>
   <a class="button" href="/admin.php?action=product_edit&id=<?php echo (int)$product['id']; ?>">Back to Product</a></p>

<table class="admin">
  <thead><tr><th>ID</th><th>SKU</th><th>Attributes</th><th>Price</th><th>Active</th><th></th></tr></thead>
  <tbody>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?php echo (int)$r['id']; ?></td>
      <td><?php echo htmlspecialchars($r['sku'] ?? ''); ?></td>
      <td><?php echo htmlspecialchars(attr_json_to_label($r['attributes_json'])); ?></td>
      <td>£<?php echo number_format($r['price_minor']/100, 2); ?></td>
      <td><?php echo $r['is_active'] ? 'Yes' : 'No'; ?></td>
      <td>
        <a class="button" href="/admin.php?action=variant_edit&id=<?php echo (int)$r['id']; ?>">Edit</a>
        <form method="post" action="/admin.php?action=variant_delete" style="display:inline" onsubmit="return confirm('Delete this variant?');">
          <?php echo CSRF::input(); ?>
          <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
          <button type="submit">Delete</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
