<h1><?php echo ($mode ?? '')==='new' ? 'Add' : 'Edit'; ?> Variant — <?php echo htmlspecialchars($product['name']); ?></h1>

<?php if (!empty($ok)): ?><div class="flash">Saved.</div><?php endif; ?>
<?php if (!empty($error)): ?><div class="flash error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

<form method="post" class="form">
  <?php echo CSRF::input(); ?>

  <label>SKU (optional)<br>
    <input type="text" name="sku" value="<?php echo htmlspecialchars($row['sku'] ?? ''); ?>">
  </label>

  <label>Attributes (one per line, “Name: Value”)<br>
    <textarea name="attributes" rows="6" placeholder="Size: Large&#10;Color: Red"><?php echo htmlspecialchars($row['attributes'] ?? ''); ?></textarea>
  </label>

  <label>Price (e.g. 12.99)<br>
    <input type="text" name="price" value="<?php echo htmlspecialchars($row['price'] ?? ''); ?>" required>
  </label>

  <label>
    <input type="checkbox" name="is_active" <?php echo !empty($row['is_active']) ? 'checked' : ''; ?>> Active
  </label>

  <p>
    <button type="submit">Save</button>
    <a class="button" href="/admin.php?action=variants&product_id=<?php echo (int)$product['id']; ?>">Back</a>
  </p>
</form>
