<h1>Subcategories</h1>
<form method="get" action="/admin.php" class="form" style="margin-bottom: .75rem;">
  <input type="hidden" name="action" value="subcategories">
  <label>Filter by Category
    <select name="category_id">
      <option value="0">— All —</option>
      <?php foreach ($cats as $c): ?>
        <option value="<?php echo (int)$c['id']; ?>" <?php echo ((int)$filter === (int)$c['id'])?'selected':''; ?>>
          <?php echo htmlspecialchars($c['name']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </label>
  <button type="submit">Filter</button>
  <a class="button" href="/admin.php?action=subcategory_new">Add Subcategory</a>
</form>

<div class="table-responsive">
<table class="admin">
  <thead><tr><th>ID</th><th>Category</th><th>Name</th><th>Slug</th><th>Active</th><th></th></tr></thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
      <tr>
        <td><?php echo (int)$r['id']; ?></td>
        <td><?php echo htmlspecialchars($r['category_name']); ?></td>
        <td><?php echo htmlspecialchars($r['name']); ?></td>
        <td><?php echo htmlspecialchars($r['slug']); ?></td>
        <td><?php echo !empty($r['is_active']) ? 'Yes' : 'No'; ?></td>
        <td>
          <a class="button" href="/admin.php?action=subcategory_edit&id=<?php echo (int)$r['id']; ?>">Edit</a>
          <form method="post" action="/admin.php?action=subcategory_delete" style="display:inline">
            <?php echo CSRF::input(); ?>
            <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
            <button type="submit">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
