<?php
// Prefetch variant counts for all listed products (single query)
$variantCounts = [];
if (!empty($products) && isset($app)) {
    $ids = array_map('intval', array_column($products, 'id'));
    if ($ids) {
        $in    = implode(',', array_fill(0, count($ids), '?'));
        $stmtC = $app->db->prepare("SELECT product_id, COUNT(*) AS c
                                    FROM product_variants
                                    WHERE product_id IN ($in)
                                    GROUP BY product_id");
        $stmtC->execute($ids);
        foreach ($stmtC as $r) {
            $variantCounts[(int)$r['product_id']] = (int)$r['c'];
        }
    }
}
?>

<h1>Products</h1>
<p><a class="button" href="/admin.php?action=product_new">Add Product</a></p>

<table class="admin">
  <thead>
    <tr>
      <th>ID</th>
      <th>Slug</th>
      <th>Name</th>
      <th>Type</th>
      <th>Variants</th>
      <th>Price</th>
      <th>Active</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
  <?php foreach ($products as $p): ?>
    <?php
      $id    = (int)$p['id'];
      $type  = ($p['product_type'] ?? 'simple');
      $vCnt  = $variantCounts[$id] ?? 0;
      $price = ($type === 'variable')
        ? '—'
        : '£' . number_format(((int)($p['price_minor'] ?? 0)) / 100, 2);
    ?>
    <tr>
      <td><?php echo $id; ?></td>
      <td><?php echo htmlspecialchars($p['slug']); ?></td>
      <td><?php echo htmlspecialchars($p['name']); ?></td>
      <td><?php echo $type === 'variable' ? 'Variable' : 'Simple'; ?></td>
      <td><?php echo $vCnt; ?></td>
      <td><?php echo $price; ?></td>
      <td><?php echo !empty($p['is_active']) ? 'Yes' : 'No'; ?></td>
      <td>
        <a class="button" href="/admin.php?action=product_edit&id=<?php echo $id; ?>">Edit</a>
        <?php if ($type === 'variable'): ?>
          <a class="button" href="/admin.php?action=variants&product_id=<?php echo $id; ?>">
            Variants (<?php echo $vCnt; ?>)
          </a>
        <?php endif; ?>
        <form method="post" action="/admin.php?action=product_delete" style="display:inline" onsubmit="return confirm('Delete this product?');">
          <?php echo CSRF::input(); ?>
          <input type="hidden" name="id" value="<?php echo $id; ?>">
          <button type="submit">Delete</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
