<h1><?php echo ($mode ?? '') === 'new' ? 'Add Product' : 'Edit Product'; ?></h1>
<?php if (!empty($ok)): ?><div class="flash">Saved.</div><?php endif; ?>
<?php if (!empty($error)): ?><div class="flash error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

<form method="post" class="form" enctype="multipart/form-data">
  <?php echo CSRF::input(); ?>

  <label>Slug<br>
    <input type="text" name="slug" value="<?php echo htmlspecialchars($product['slug']); ?>" required>
  </label>

  <label>Name<br>
    <input type="text" name="name" value="<?php echo htmlspecialchars($product['name']); ?>" required>
  </label>
	
<fieldset style="border:1px solid #ddd; padding:.75rem; border-radius:.375rem; margin:.75rem 0;">
  <legend>Product Type</legend>
  <?php $ptype = $product['product_type'] ?? 'simple'; ?>
  <label><input type="radio" name="product_type" value="simple" <?php echo $ptype==='simple'?'checked':''; ?>> Simple</label>
  <label style="margin-left:1rem;"><input type="radio" name="product_type" value="variable" <?php echo $ptype==='variable'?'checked':''; ?>> Variable (use variants for price)</label>
  <?php if (($mode ?? '') === 'edit' && $ptype === 'variable'): ?>
    <p style="margin:.5rem 0 0;"><a class="button" href="/admin.php?action=variants&product_id=<?php echo (int)$product['id']; ?>">Manage Variants<?php
      if (!empty($variant_count)) echo ' ('.$variant_count.')';
    ?></a></p>
  <?php endif; ?>
</fieldset>

<!-- Price field: show only for simple products -->
<label>Price (e.g. 12.99)<br>
  <input type="text" name="price" value="<?php echo number_format(($product['price_minor'] ?? 0)/100,2); ?>" <?php echo (($product['product_type'] ?? 'simple')==='variable') ? 'disabled' : ''; ?>>
</label>
<p class="muted" style="margin-top:.25rem;"><?php if (($product['product_type'] ?? 'simple') === 'variable') echo 'Price is set on each variant.'; ?></p>


  <label>Description<br>
    <textarea name="description" rows="6"><?php echo htmlspecialchars($product['description']); ?></textarea>
  </label>

  <label>Price (e.g. 12.99)<br>
    <input type="text" name="price" value="<?php echo number_format(($product['price_minor'] ?? 0)/100,2); ?>">
  </label>

  <fieldset style="border:1px solid #ddd; padding:.75rem; border-radius:.375rem; margin:.75rem 0;">
    <legend>Classification</legend>

    <label>Category<br>
      <select name="category_id">
        <option value="0">— None —</option>
        <?php foreach (($categories ?? []) as $c): ?>
          <option value="<?php echo (int)$c['id']; ?>" <?php echo ((int)($product['category_id'] ?? 0) === (int)$c['id']) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($c['name']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>

    <label style="margin-top:.5rem;">Subcategory<br>
      <select name="subcategory_id">
        <option value="0">— None —</option>
        <?php foreach (($subcategories ?? []) as $sc): ?>
          <option value="<?php echo (int)$sc['id']; ?>" <?php echo ((int)($product['subcategory_id'] ?? 0) === (int)$sc['id']) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($sc['name']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>

    <p class="muted" style="margin:.5rem 0 0 0;">
      Choose a category and click “Update subcategories” to refresh the subcategory list.
    </p>
    <p style="margin:.5rem 0 0 0;">
      <button type="submit" name="refresh" value="1">Update subcategories</button>
    </p>
  </fieldset>

  <fieldset style="border:1px solid #ddd; padding:.75rem; border-radius:.375rem; margin:.75rem 0;">
    <legend>Product Image</legend>

    <p class="muted" style="margin-top:0">
      You can upload an image file or provide an Image URL. If both are provided, the uploaded file will be used.
    </p>

    <label>Upload Image (JPG/PNG/GIF/WEBP, max 5MB)<br>
      <input type="file" name="image_file" accept=".jpg,.jpeg,.png,.gif,.webp,image/jpeg,image/png,image/gif,image/webp">
    </label>

    <label style="margin-top:.5rem;">Image URL (optional)<br>
      <input type="text" name="image" value="<?php echo htmlspecialchars($product['image'] ?? ''); ?>">
    </label>

    <?php if (!empty($product['image'])): ?>
      <p class="muted" style="margin:.5rem 0 0 0;">Current: <code><?php echo htmlspecialchars($product['image']); ?></code></p>
      <?php if (preg_match('~^/uploads/|^https?://~i', $product['image'])): ?>
        <div style="margin-top:.5rem;">
          <img src="<?php echo htmlspecialchars($product['image']); ?>" alt="" style="max-width:240px;height:auto;border:1px solid #ddd;padding:2px;border-radius:4px;">
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </fieldset>

  <label>
    <input type="checkbox" name="is_active" <?php echo !empty($product['is_active']) ? 'checked' : ''; ?>> Active
  </label>

  <p>
    <button type="submit">Save</button>
    <a class="button" href="/admin.php?action=products">Back</a>
  </p>
</form>
