<h1>Order <?php echo htmlspecialchars($order['order_id']); ?></h1>

<p><strong>Total:</strong>
  <?php echo htmlspecialchars($order['currency']); ?>
  <?php echo number_format(((int)$order['total_minor'])/100, 2); ?>
</p>

<p><strong>Status:</strong> <?php echo htmlspecialchars($order['status']); ?></p>

<?php if (!empty($order['created_at'])): ?>
  <p class="muted"><strong>Created:</strong> <?php echo htmlspecialchars($order['created_at']); ?></p>
<?php endif; ?>

<?php if (!empty($order['btcpay_invoice_id'])): ?>
  <p class="muted">
    <strong>BTCPay Invoice ID:</strong>
    <code><?php echo htmlspecialchars($order['btcpay_invoice_id']); ?></code>
  </p>
  <form method="post" style="margin:.5rem 0 1rem 0;">
    <?php echo CSRF::input(); ?>
    <button type="submit" name="refresh_invoice" value="1">Refresh from BTCPay</button>
  </form>
<?php endif; ?>

<p><strong>Customer:</strong>
  <?php echo htmlspecialchars($order['name']); ?>,
  <?php echo htmlspecialchars($order['email']); ?>
</p>

<h2>Encrypted Name + Address</h2>
<textarea readonly rows="10" style="width:100%;font-family:ui-monospace,Menlo,monospace;"><?php
  // This field now stores ASCII-armored PGP, not plaintext
  echo htmlspecialchars($order['address'] ?? '');
?></textarea>
<p style="margin:.5rem 0 1rem;">
  <a class="button"
     href="data:text/plain;charset=utf-8,<?php echo rawurlencode($order['address'] ?? ''); ?>"
     download="order_<?php echo htmlspecialchars($order['order_id']); ?>_address.asc">
     Download .asc
  </a>
</p>

<h2>Items</h2>
<table class="admin">
  <thead>
    <tr><th>Product</th><th>Qty</th><th>Price</th><th>Total</th></tr>
  </thead>
  <tbody>
  <?php foreach ($lines as $l): ?>
    <tr>
      <td><?php echo htmlspecialchars($l['name']); ?></td>
      <td><?php echo (int)$l['qty']; ?></td>
      <td><?php echo number_format(((int)$l['price_minor'])/100, 2); ?></td>
      <td><?php echo number_format((((int)$l['price_minor']*(int)$l['qty']))/100, 2); ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>

<h2>Update Status</h2>
<?php if (!empty($ok)): ?><div class="flash">Status updated.</div><?php endif; ?>
<?php if (!empty($error)): ?><div class="flash error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

<form method="post">
  <?php echo CSRF::input(); ?>
  <label>New Status
    <select name="status">
      <?php foreach (['pending','processing','paid','shipped','completed','cancelled'] as $s): ?>
        <option value="<?php echo $s; ?>" <?php echo (($order['status'] ?? '') === $s) ? 'selected' : ''; ?>>
          <?php echo ucfirst($s); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </label>
  <p>
    <button type="submit">Update</button>
    <a class="button" href="/admin.php?action=orders">Back</a>
  </p>
</form>
