<?php if (!empty($challenge)): ?>
  <h1>Admin Login — Step 2 (PGP Verification)</h1>
  <?php if (!empty($error)): ?>
  <div class="flash error">
    <?php echo htmlspecialchars($error); ?>
  </div>
<?php endif; ?>

  <p class="muted">
    Decrypt the message below with your PGP private key. You’ll get a short verification code.
    Paste that code to sign in. The challenge expires in 5 minutes.
  </p>

  <label>PGP Encrypted Message<br>
    <textarea class="select-all" readonly rows="12" style="width:100%;font-family:ui-monospace,Menlo,monospace;.select-all:focus { user-select: all; }"><?php echo htmlspecialchars($challenge); ?></textarea>
  </label>

  <form method="post" action="/admin.php?action=login" class="form" style="margin-top:.75rem;">
    <?php echo CSRF::input(); ?>
    <input type="hidden" name="step" value="verify">
    <label>Verification Code<br><input type="text" name="code" required></label>
    <p><button type="submit">Verify &amp; Sign in</button></p>
  </form>

<?php else: ?>
  <h1>Admin Login</h1>
  <?php if (!empty($error)): ?><div class="flash error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

  <form method="post" action="/admin.php?action=login" class="form">
    <?php echo CSRF::input(); ?>
    <input type="hidden" name="step" value="password">
    <label>Username<br><input type="text" name="username" required></label>
    <label>Password<br><input type="password" name="password" required></label>
    <p><button type="submit">Continue</button></p>
  </form>
<?php endif; ?>

<script>
  (function(){
    var ta = document.getElementById('challenge');
    if (ta) { ta.focus(); ta.select(); }
  })();
</script>
