<!doctype html>


<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Onion Factory</title>
    <link rel="stylesheet" href="/styles.css">
  </head>
  <body>
    <header class="site-header">
		<div class="top">
			  <p>You Don’t Peel This Deep Without Trust.</p>
		  </div>
      <div class="nav-container">
  <div class="inner">
    <a class="brand" href="/index.php"><img src="/logo.svg" alt="Onion Factory" /></a>

    <!-- Hidden toggle + burger button -->
    <input type="checkbox" id="nav-toggle" class="nav-toggle" aria-hidden="true">
    <label for="nav-toggle" class="nav-burger" aria-label="Toggle navigation" aria-controls="primary-menu">
      <span></span><span></span><span></span>
    </label>

    <nav id="primary-menu" class="nav" aria-label="Primary">
  <ul class="menu">
    <?php if (!empty($navCats)): ?>
      <?php foreach ($navCats as $c): ?>
        <?php
          $cid     = (int)$c['id'];
          $hasKids = !empty($children[$cid]);
          $catUrl  = $base.'/index.php?page=category&amp;slug='.htmlspecialchars($c['slug']);
        ?>
        </li>
        <li class="<?php echo $hasKids ? 'has-sub' : ''; ?>">
          <a href="<?php echo $catUrl; ?>" <?php echo $hasKids ? 'aria-haspopup="true"' : ''; ?>>
            <?php echo htmlspecialchars($c['name']); ?>
          </a>

          <?php if ($hasKids): ?>
			<ul class="submenu" aria-label="<?php echo htmlspecialchars($c['name']); ?> subcategories">
				<li>
					<a href="<?php echo $catUrl; ?>"><strong>View all <?php echo htmlspecialchars($c['name']); ?></strong></a>
				</li>
				<?php foreach ($children[$cid] as $sc): ?>
				<li>
					<a href="<?php echo $catUrl; ?>&amp;sub=<?php echo htmlspecialchars($sc['slug']); ?>">
						<?php echo htmlspecialchars($sc['name']); ?>
					</a>
				</li>
				<?php endforeach; ?>
  </ul>
<?php endif; ?>

        </li>
      <?php endforeach; ?>
    <?php else: ?>
      <li><em>No categories</em></li>
    <?php endif; ?>
  </ul>

  <a class="cart-link" href="<?php echo $base; ?>/index.php?page=cart">Cart</a>
</nav>

  </div>

<picture>
			  <source media="(max-width: 767px)" srcset="/banner-mob.jpg">
			  <img src="/banner.jpg" alt="Banner">
		  </picture>
</div>
    </header>
    <main class="container">
