<?php
class CSRF {
    public static function token(): string {
        if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        return hash_hmac('sha256', $_SESSION['csrf_token'], 'dev-secret-change-me');
    }
    public static function input(): string { return '<input type="hidden" name="csrf_token" value="'.htmlspecialchars(self::token(), ENT_QUOTES).'">'; }
    public static function check(): void {
        $valid = isset($_POST['csrf_token']) && hash_equals(self::token(), $_POST['csrf_token']);
        if (!$valid) { http_response_code(400); echo 'Bad Request (CSRF)'; exit; }
    }
}