<?php
class CSRF
{
    /** Set from config at bootstrap on every request */
    private static string $secret = 'f0055bc2a3d32b0be2c9433c2fa03f555065c5bbbfc4b9b7fc93878df17974c2';

    /** Call this once early (after config is loaded). */
    public static function bootstrap(string $secret): void
    {
        if ($secret !== '') self::$secret = $secret;
    }

    /** Ensure we have a session id to bind the token to (no server-side data used). */
    private static function sid(): string
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start(); // only to read the client’s session id cookie
        }
        $sid = session_id();
        // If for some reason there is still no SID, use a per-request fallback (rare)
        if ($sid === '') {
            $sid = '_anon_' . ($_SERVER['REMOTE_ADDR'] ?? '') . '|' . ($_SERVER['HTTP_USER_AGENT'] ?? '');
        }
        return $sid;
    }

    /**
     * Stateless token = HMAC(secret, session_id + current-hour bucket)
     * Accept current and previous hour to allow small clock skew.
     */
    public static function token(): string
    {
        $sid = self::sid();
        $bucket = (int) floor(time() / 3600);
        return hash_hmac('sha256', $sid . '|' . $bucket, self::$secret);
    }

    public static function input(): string
    {
        return '<input type="hidden" name="csrf_token" value="' .
               htmlspecialchars(self::token(), ENT_QUOTES, 'UTF-8') . '">';
    }

    public static function check(): void
    {
        $provided = (string)($_POST['csrf_token'] ?? $_GET['csrf_token'] ?? '');
        if ($provided === '') {
            http_response_code(400); echo 'Bad Request (CSRF)'; exit;
        }

        $sid = self::sid();
        $nowBucket = (int) floor(time() / 3600);
        $valid = false;

        foreach ([0, -1] as $delta) { // allow previous hour for skew
            $expect = hash_hmac('sha256', $sid . '|' . ($nowBucket + $delta), self::$secret);
            if (hash_equals($expect, $provided)) { $valid = true; break; }
        }

        if (!$valid) { http_response_code(400); echo 'Bad Request (CSRF)'; exit; }
    }
}
