<?php
//ini_set('session.name', 'OFSESSID');
//ini_set('session.cookie_samesite', 'Lax');
//ini_set('session.cookie_httponly', '1');
class App
{
    public PDO $db;
    public array $cfg;

    public function __construct()
    {
        $this->cfg = require __DIR__ . '/config.php';
        $dsn = sprintf(
            'mysql:host=%s;dbname=%s;charset=%s',
            $this->cfg['db']['host'],
            $this->cfg['db']['name'],
            $this->cfg['db']['charset']
        );

        $this->db = new PDO(
            $dsn,
            $this->cfg['db']['user'],
            $this->cfg['db']['pass'],
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            ]
        );
        
        require_once __DIR__ . '/SessionDB.php';
        $ttl = $this->cfg['session']['ttl'] ?? 7*24*60*60; // optional in config.php
        $handler = new SessionDB($this->db, (int)$ttl);
        session_set_save_handler($handler, true);

        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function baseUrl(): string
    {
        return rtrim(
            $this->cfg['base_url']
                ?: ((($_SERVER['HTTPS'] ?? 'off') === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST']),
            '/'
        );
    }

    public function render(string $tpl, array $data = []): void
    {
        extract($data, EXTR_SKIP);
        $base = $this->baseUrl();
		$asset = function (?string $path) use ($base): string {
			if (!$path) return '';
			if (preg_match('~^https?://~i', $path)) return $path;          // already absolute
			return rtrim($base, '/').'/'.ltrim($path, '/');                 // prefix site base
		};
		// Build nav categories (active cats that have at least one active product)
    // ================= Nav data =================
$navCats = [];
$children = [];

try {
    // 1) PARENTS: active categories that either
    //    (a) have active products directly, OR
    //    (b) have at least one active subcategory (optionally with active products)
    $sqlParents = "
        SELECT c.id, c.name, c.slug
        FROM categories c
        WHERE c.is_active = 1
          AND (
                EXISTS (SELECT 1 FROM products p
                        WHERE p.category_id = c.id AND p.is_active = 1)
             OR EXISTS (SELECT 1 FROM subcategories s
                        WHERE s.category_id = c.id AND s.is_active = 1)
          )
        ORDER BY c.name
    ";
    $navCats = $this->db->query($sqlParents)->fetchAll();

    if ($navCats) {
        $parentIds = array_column($navCats, 'id');
        $in = implode(',', array_fill(0, count($parentIds), '?'));

        // 2) SUBCATS: active subcategories for those parents
        // OPTIONAL product filter:
        //   If your products table has a `subcategory_id` column and you only want
        //   subcategories that contain active products, keep the EXISTS block.
        //   If not, remove the EXISTS block entirely.
        $sqlChildren = "
            SELECT s.id, s.name, s.slug, s.category_id
            FROM subcategories s
            WHERE s.is_active = 1
              AND s.category_id IN ($in)
              AND (
                    EXISTS (SELECT 1 FROM products p
                            WHERE p.subcategory_id = s.id AND p.is_active = 1)
                 OR EXISTS (SELECT 1 FROM products p2
                            WHERE p2.category_id = s.category_id AND p2.is_active = 1)
                  )
            ORDER BY s.name
        ";
        $stmt = $this->db->prepare($sqlChildren);
        $stmt->execute($parentIds);
        foreach ($stmt->fetchAll() as $row) {
            $children[$row['category_id']][] = $row;
        }
    }
} catch (\Throwable $e) {
    $navCats = [];
    $children = [];
}

        include __DIR__ . '/../templates/_header.php';
        include __DIR__ . '/../templates/' . $tpl . '.php';
        include __DIR__ . '/../templates/_footer.php';
    }
}
