<?php
class AdminAuth {
    public static function isLoggedIn(): bool { return !empty($_SESSION['admin_id']); }
    public static function requireLogin(): void { if (!self::isLoggedIn()) { header('Location: /admin.php?action=login'); exit; } }
    public static function login(App $app, string $u, string $p): bool {
        $stmt=$app->db->prepare('SELECT id,username,passhash FROM admin_users WHERE username=? LIMIT 1'); $stmt->execute([$u]);
        if ($row=$stmt->fetch()) { if (password_verify($p,$row['passhash'])) { $_SESSION['admin_id']=(int)$row['id']; $_SESSION['admin_name']=$row['username']; return true; } }
        return false;
    }
    public static function logout(): void { unset($_SESSION['admin_id'],$_SESSION['admin_name']); }
    public static function hasAnyAdmin(App $app): bool { return (int)$app->db->query('SELECT COUNT(*) c FROM admin_users')->fetch()['c']>0; }
}